/*
 * Decompiled with CFR 0.152.
 */
package com.dfdyz.epicacg.utils;

import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;

public class MathUtils {
    public static final Double PI2 = Math.PI * 2;
    public static final Quaternionf Quat_One = new Quaternionf();
    public static final float RADIANS_TO_DEGREES = (float)Math.PI / 180;

    public static Vec3 ToCylindricalCoordinate(Vec3 in) {
        double at = Math.atan2(-in.f_82481_, in.f_82479_);
        double r = Math.sqrt(in.f_82479_ * in.f_82479_ + in.f_82481_ * in.f_82481_);
        return new Vec3(r, at, in.f_82480_);
    }

    public static Vec3 LerpMinCylindrical(Vec3 v1, Vec3 v2, float t) {
        double v = (v2.f_82480_ - v1.f_82480_) % PI2;
        if (v > 0.0) {
            v = Math.abs(v -= PI2.doubleValue()) > v + PI2 ? v + PI2 : v;
        }
        return new Vec3(v1.f_82479_ * (double)(1.0f - t) + v2.f_82479_ * (double)t, v1.f_82480_ + v * (double)t, v1.f_82481_ * (double)(1.0f - t) + v2.f_82481_ * (double)t);
    }

    public static Quaternionf fromEuler(float yaw, float pitch, float roll) {
        return new Quaternionf().rotateZ(roll).rotateX(pitch).rotateY(yaw);
    }

    public static float lerpBetween(float f1, float f2, float zero2one) {
        float f = 0.0f;
        for (f = f2 - f1; f < -180.0f; f += 360.0f) {
        }
        while (f >= 180.0f) {
            f -= 360.0f;
        }
        return f1 + zero2one * f;
    }

    public static Vec3 ToCartesianCoordinates(Vec3 in) {
        return new Vec3(in.f_82479_ * Math.cos(in.f_82480_), in.f_82481_, in.f_82479_ * Math.sin(-in.f_82480_));
    }

    public static float toDegrees(float angrad) {
        return angrad * ((float)Math.PI / 180);
    }
}

